#include "pch.h"
#include "listop.h"

void CListOp::alignDescription(const char* desc,			// description to align
							   std::string& alignedDesc,	// where to place the result
							   int lineLength,				// length of each line
							   const char* lineSeparator,	// line separator (e.g. CR\0, LF\0, CRLF\0 or something else)
							   int prefixLength,			// length of empty space in the beginning of each line
							   int firstPrefixLength		// assumed length of the beginning of first line (first line will have no prefix)
															// default value is -1
							   )
{
	// we need both description and line separator
	assert( desc != NULL && lineSeparator != NULL );
	// we need correct numbers
	assert( lineLength > 0 && prefixLength >= 0 && firstPrefixLength >= -1);
	assert( prefixLength < lineLength );
	
	if (firstPrefixLength == -1) {
		firstPrefixLength = prefixLength;
	}

	alignedDesc.clear();

	int	limit;		// number of description symbols allowed per line
	int	nextLimit;	// the same but in the next line

	int	lineNumber = 0;
	while (desc[0] != '\0') {
		++lineNumber;	// now we have current line number

		// cut beginning spaces
		while (desc[0] == ' ') {
			++desc;
		}
		if (desc[0] == '\0') {
			break;
		}

		if (lineNumber == 1) {
			// first line
			limit = lineLength - firstPrefixLength;
			// it is possible that first line beginning is equal or greater than allowed line length
			// in this case we start description from the second line
			if (limit <= 0) {
				continue;
			}
			nextLimit = lineLength - prefixLength;
		} else {
			// not first line
			alignedDesc.append( lineSeparator );
			if (prefixLength > 0) {
				alignedDesc.append( prefixLength, ' ' );
			}
			limit     = lineLength - prefixLength;
			nextLimit = limit;
		}

		int	wordNumber = 0;
		while (limit > 0) {
			// find next word
			++wordNumber;
			if (wordNumber > 1) {
				--limit;	// don't forget about space between words
				if (limit == 0) {
					break;
				}
			}

			// skip spaces
			while (desc[0] == ' ') {
				++desc;
			}
			if (desc[0] == '\0') {
				break;
			}

			// determine word length
			int	wordLen = 1;
			while (desc[wordLen] != '\0' && desc[wordLen] != ' ') {
				++wordLen;
			}
			if (wordLen > limit) {
				// it is possible that word length > next line length => we should separate word this case
				if (wordLen > nextLimit) {
					// split word by limit
					wordLen = limit;
					if (wordNumber > 1) {
						alignedDesc.append( 1, ' ' );
					}
					alignedDesc.append( desc, wordLen );
					desc  += wordLen;
					limit -= wordLen;
				} else {
					// stop this line, word will be at the beginning of next line
					break;
				}
			} else {
				if (wordNumber > 1) {
					alignedDesc.append( 1, ' ' );
				}
				alignedDesc.append( desc, wordLen );
				desc  += wordLen;
				limit -= wordLen;
			}
		}
	}
}
